// Hotwright Inc. All rights reserved (c) 2021-2023
// Read and write to kria board via threads  
// hotstate machine structure for runtime loading.
#ifndef _KRIA
#define _KRIA


extern void *read_kria(void *);
extern void *write_kria(void *);

typedef struct READ_PARAMS {
        char     *data_out;
        uint64_t volatile *baseaddress;
	uint64_t volatile *statusbase;
	uint64_t words_read;
	uint64_t flush_char;
	uint64_t *write_done;
} ReadParams_t;

typedef struct WRITE_PARAMS {
        char     *data_in;
        uint64_t volatile *baseaddress;
	uint64_t volatile *statusbase;
        uint64_t size_in_bytes;
        uint64_t fifo_size;
	uint64_t *write_done;
} WriteParams_t;

#endif
