#include <stdio.h>
#include <stdlib.h>
#include <stdint.h>
#include <sys/types.h>
#include <hot.h>

      // expects an AXI stream to a FIFO. 
void loadsmdata(volatile uint64_t *base_address, hot_t *hot) {
if (hot->smdata_length > 0 ) {
    for(int i = 0; i < hot->smdata_length; i++) {
      base_address[i] = hot->smdata[i];
    }
  }
}

void loaduberLUT(volatile uint64_t *base_address, hot_t *hot) {
     if (hot->uberLUT_length > 0 ) {
          int num_words = 0;
          if (hot->uberLUT_length%64 == 0) num_words = hot->uberLUT_length/64;
          else num_words = hot->uberLUT_length/64 + 1;	
          for(int i = 0; i < num_words; i++) {
           for (int j = 0; j<64;j++) {
             base_address[j] = (((uint64_t) hot->uberLUTdata[i])>>j)&(uint64_t) 1;
      }
    }
  }
}

void loadtimermem(volatile uint64_t *base_address, hot_t *hot) {
if (hot->timermem_length > 0 ) {
    for(int i = 0; i < hot->timermem_length; i++) {
      *(base_address + i) = hot->timermemdata[i];
    }
  }
}

void loadswitchmem(volatile uint64_t *base_address, hot_t *hot) {
if (hot->switchmem_length > 0 ) {
    for(int i = 0; i < hot->switchmem_length; i++) {
      *(base_address + i) = hot->switchmemdata[i];
    }
  }
}

void hot_reset(volatile uint64_t *base_address) {
    *(base_address) = 1;
    *(base_address) = 0;
}

void hot_start(volatile uint64_t *base_address) {
    *(base_address) = 0;
}

void hot_stop(volatile uint64_t *base_address) {
    *(base_address) = 2;
}

uint64_t hotstatus(volatile uint64_t *base_address) {
    return(*(base_address));
}
