`timescale 10ns / 1ns
// Module for varible ram
// n in and 1 out
// Steve Cassselman (c) 2020

(* dont_touch = "yes" *) module variable #(
               parameter NUM_VARS = 6,
               parameter NUM_VARSEL = 2,
               parameter NUM_VARSEL_BITS = 3,
               parameter string FILENAME = "",
               parameter STANDALONE = 0
               )(
               input clk,
               input rst,
               input [NUM_VARS-1:0] variable,
               input [NUM_VARSEL_BITS-1:0] varSel,
               input vardata,
               input varload,
               output ready,
              //(* syn_keep = "true" *) 
              output lhs
               );


reg [0:0] code [(NUM_VARSEL*2**(NUM_VARS))-1:0] ;
if (STANDALONE == 1)
initial $readmemb(FILENAME,code,0,(NUM_VARSEL*2**(NUM_VARS))-1);

wire [NUM_VARS+NUM_VARSEL_BITS-1:0] var_ram_address;

generate 
if (STANDALONE == 0) begin
reg [NUM_VARS+NUM_VARSEL_BITS-1:0] load_addr;
always @ (posedge clk) begin
if (rst == 1) load_addr <= 0;
else if (varload == 1) begin 
 code[load_addr] <= vardata;
 load_addr <= load_addr + 1;
 end
end

assign ready = rst?0:load_addr >= (NUM_VARSEL*2**NUM_VARS);
end
endgenerate

assign var_ram_address = {varSel,variable};
assign lhs =  code[var_ram_address];


endmodule
