// Copyright (c) 2021-2022 HotWright Inc.
// Created Fri Dec 16 08:16:22 2022

// This file is machine generated, edit at your own risk

`timescale 1ns/1ns


module parser_tb;

// resets the machine and start at address 0 
reg rst; 
// halts at the current address of the machine 
reg hlt; 
reg clk;

reg interrupt;

wire [4:0] debug_adr; //watch the internal address
reg [4:0] interrupt_address = 5'h0;

wire [9:0] variables;
wire [2:0] states;


//output states
assign read_data = states[0];
assign write_data = states[1];
assign next_data = states[2];


//input variables
wire valid ;
wire next_wrap_around ;
wire din7 ;
wire din6 ;
wire din5 ;
wire din4 ;
wire din3 ;
wire din2 ;
wire din1 ;
wire din0 ;

assign variables = { valid, next_wrap_around, din7, din6, din5, din4, din3, din2, din1, din0 };


wire ready;




hotstate #(
	.NUM_STATES (3),
	.NUM_VARS (10),
	.NUM_VARSEL (6),
	.NUM_VARSEL_BITS (3),
	.NUM_TIMERS (0),
	.NUM_ADR_BITS (5),
	.NUM_CTL_BITS (18),
	.NUM_SWITCHES (0),
	.SWITCH_MEM_WORDS (0),
	.NUM_SWITCH_BITS (1),
	.SWITCH_OFFSET_BITS (0),
	.NUM_WORDS (23),
	.STACK_DEPTH (4),
	.TIM_MEM_WORDS (0),
	.TIM_WIDTH (32),
	.MCFILENAME ("parser_smdata.mem"),
	.VRFILENAME ("parser_vardata.mem"),
	.STANDALONE (1)
	) parser_sm  (
	.variables(variables),
	.states(states),
	.interrupt(interrupt),
	.interrupt_address(interrupt_address),
	.debug_adr(debug_adr),
	.hlt(hlt),
	.rst(rst),
	.ready(ready),
	.clk(clk)
);

initial begin

interrupt = 0;
clk = 0;
hlt = 0;
rst = 1;

end //end of inital

always #40 rst = 0;
always #10 clk = ~clk;

`include "user.v"

endmodule
