// Hotwright Inc. All rights reserved (c) 2021-2023
// Hardware Object Technology 
// hotstate machine structure for runtime loading.
#ifndef _HOT
#define _HOT
typedef struct hot {
  uint32_t smdata_length;
  uint32_t smdata_width;
  uint32_t uberLUT_length;
  uint32_t uberLUT_width;
  uint32_t timermem_length;
  uint32_t timermem_width;
  uint32_t switchmem_length;
  uint32_t switchmem_width;
  uint64_t *smdata;
  uint64_t *uberLUTdata;
  uint64_t *timermemdata;
  uint64_t *switchmemdata;
  } hot_t;

extern void loadsmdata(volatile uint64_t *base_address, hot_t *hot);
extern void loaduberLUT(volatile uint64_t *base_address, hot_t *hot);
extern void loadtimermem(volatile uint64_t *base_address, hot_t *hot);
extern void loadswitchmem(volatile uint64_t *base_address, hot_t *hot);

extern void hot_start (volatile uint64_t *);
extern void hot_stop (volatile uint64_t *);
extern void hot_reset (volatile uint64_t *);

#endif
