// Copyright (c) Hotwright Inc. 2022-2023
// decodes riscv opcodes for RV32I
// statex bits to control the architecture

#include "opcodes.h"


bool state0 = 0;
bool state1 = 0;
bool state2 = 0;
bool state3 = 0;
bool state4 = 0;
bool state5 = 0;

char opcode_in;// should use compiler option -w 7


void main() {
    while(1) {
    switch (opcode_in) {
    /*lb, lh, lw, lbu, lhu*/
    case lb:{state0 = 1, state1 = 0; continue;}
    /*fence, fence.i*/
    case fence:{state2 = 1, state3 = 0; continue;}
    /*addi, slti, sltiu, xori, ori, andi, slli, srli, srai*/
    case addi:{state2 = 1, state3 = 0; continue;}
    case auipc:{state2 = 1, state3 = 0; continue;}
    /*sb, sh, sw*/
    case sb:{state2 = 1, state3 = 0; continue;}
    /*add, sub, ssl, slt, sltu, xor, srl, sra, or, and*/ 
    case add:{state2 = 1, state3 = 0; continue;}
    /*beq, bne, blt, bge, bltu, bgeu*/
    case beq:{state2 = 1, state3 = 0; continue;}
    case jalr:{state2 = 1, state3 = 0; continue;}
    case jal:{state2 = 1, state3 = 0; continue;}
    /*ecall, ebreak, csrrw, csrrs, csrrwi, csrrsi, csrrci*/
    case ecall:{state4 = 1, state5 = 0; continue;}
    default:{break;} /* not an opcode*/
}
}
}
    
