// Copyright (c) 2021-2022 HotWright Inc.
// Created Fri Dec 16 10:26:59 2022

// This file is machine generated, edit at your own risk

`timescale 1ns/1ns


module parserRL_tb;

// resets the machine and start at address 0 
reg rst; 
// halts at the current address of the machine 
reg hlt; 
reg clk;

reg [23:0] sm_tdata [23:0];
reg sm_tvalid; 
reg [0:0] var_tdata [6143:0]; 
reg var_tvalid; 
reg [23:0] smdata_word;
reg vardata_bit;

reg interrupt;

wire [4:0] debug_adr; //watch the internal address
reg [4:0] interrupt_address = 5'h0;

wire [9:0] variables;
wire [2:0] states;


//output states
assign pop = states[0];
assign push = states[1];
assign cr_data = states[2];


//input variables
wire valid ;
wire cr_wrap_around ;
wire din7 ;
wire din6 ;
wire din5 ;
wire din4 ;
wire din3 ;
wire din2 ;
wire din1 ;
wire din0 ;

assign variables = { valid, cr_wrap_around, din7, din6, din5, din4, din3, din2, din1, din0 };


wire ready;

integer smdata_count;

integer vardata_count;




hotstate #(
	.NUM_STATES (3),
	.NUM_VARS (10),
	.NUM_VARSEL (6),
	.NUM_VARSEL_BITS (3),
	.NUM_TIMERS (0),
	.NUM_ADR_BITS (5),
	.NUM_CTL_BITS (18),
	.NUM_SWITCHES (0),
	.SWITCH_MEM_WORDS (0),
	.NUM_SWITCH_BITS (1),
	.SWITCH_OFFSET_BITS (0),
	.NUM_WORDS (24),
	.STACK_DEPTH (4),
	.TIM_MEM_WORDS (0),
	.TIM_WIDTH (32),
	.STANDALONE (0)
	) parserRL_sm  (
	.variables(variables),
	.states(states),
	.sm_tdata(smdata_word),
	.sm_tvalid(sm_tvalid),
	.var_tdata(vardata_bit),
	.var_tvalid(var_tvalid),
	.interrupt(interrupt),
	.interrupt_address(interrupt_address),
	.debug_adr(debug_adr),
	.hlt(hlt),
	.rst(rst),
	.ready(ready),
	.clk(clk)
);

initial begin

$readmemh("parserRL_smdata.mem", sm_tdata,0,23);
$readmemb("parserRL_vardata.mem", var_tdata,0,6143);

interrupt = 0;
clk = 0;
hlt = 0;
rst = 1;
smdata_count = 0;
vardata_count = 0;

end //end of inital

always #40 rst = 0;
always #10 clk = ~clk;
always @(posedge clk) begin :load_sm_data
           if (rst == 1) begin
           sm_tvalid <= 0;
           smdata_word <= 0;
           end
           else if (smdata_count < 24) begin
           sm_tvalid <= 1;
           smdata_word <= sm_tdata[smdata_count];
           smdata_count = smdata_count + 1;
           end
           else sm_tvalid <= 0;
end

always @(posedge clk) begin :load_var_tdata
           if (rst == 1) begin
           var_tvalid <= 0;
           vardata_bit <= 0;
           end
           else if (vardata_count < 6144) begin
           var_tvalid <= 1;
           vardata_bit <= var_tdata[vardata_count];
           vardata_count = vardata_count + 1;
           end
           else var_tvalid <= 0;
end


`include "user.v"

endmodule
